//
//  RMAppKit.h
//  RMAppKit
//
//  Created by Keith Duncan on 25/04/2011.
//  Copyright 2011 Realmac Software. All rights reserved.
//

#import <TargetConditionals.h>

#import <Foundation/Foundation.h>

#if !TARGET_OS_IPHONE

/*
	AppKit Only
 */

#import <AppKit/AppKit.h>

//
//	View
//

#import "RMAppKit/RMOptionallyKeyWindow.h"
#import "RMAppKit/RMColorView.h"
#import "RMAppKit/RMCropHandlesView.h"

//
//	View Controllers
//

#import "RMAppKit/RMAlertViewController.h"

//
//	Animation
//

#import "RMAppKit/RMAnimation+Functions.h"

//
//	Protocols
//

#import "RMAppKit/RMDraggingInfo.h"
#import "RMAppKit/RMKeyValueBinding.h"

//
//	Categories
//

#import "RMAppKit/NSBundle+RMAdditions.h"

#import "RMAppKit/NSControl+RMAdditions.h"
#import "RMAppKit/NSView+RMAdditions.h"
#import "RMAppKit/NSWindow+RMAdditions.h"

#import "RMAppKit/NSColor+RMAdditions.h"
#import "RMAppKit/NSBezierPath+RMAdditions.h"
#import "RMAppKit/CAAnimation+RMAdditions.h"
#import "RMAppKit/NSImage+RMAdditions.h"
#import "RMAppKit/NSBitmapImageRep+RMAdditions.h"

//
//	Functions
//

#import "RMAppKit/RMRelaunch.h"

#else

/*
	UIKit Only
 */

#import <UIKit/UIKit.h>

//
//	Categories
//

#import "RMAppKit/UIResponder+RMAdditions.h"

#endif /* !TARGET_OS_IPHONE */

/*
	Common
 */

//
//	Layer
//

#import "RMAppKit/RMIndeterminateProgressIndicatorLayer.h"

//
//	Images
//

#import "RMAppKit/RMImage.h"

//
//	Categories
//

#import "RMAppKit/CALayer+RMAdditions.h"
#import "RMAppKit/CGPath+RMAdditions.h"

//
//	Functions
//

#import "RMAppKit/RMGeometry.h"

//
//	Other
//

#import "RMAppKit/RMAppKit-Constants.h"
